<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'kadence-global','kadence-header','kadence-content','kadence-footer' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );


add_action('wp_enqueue_scripts', function() {
  wp_enqueue_script('simple-parallax', 'https://cdn.jsdelivr.net/npm/simple-parallax-js@5.6.2/dist/simpleParallax.min.js', [], null, true);
  wp_add_inline_script('simple-parallax', "
    document.addEventListener('DOMContentLoaded', function() {
      var images = document.querySelectorAll('.parallax-image');
      new simpleParallax(images, {
        scale: 1.3,
        delay: 0.3,
        transition: 'cubic-bezier(0,0,0,1)'
      });
    });
  ");
});



/**
 * Shortcode: [practice_marquee parent="practice-areas" limit="9" speed="22s" maxheight="280"]
 * - parent: slug of the parent page (default "practice-areas")
 * - limit: number of child pages to show (default 9)
 * - speed: CSS duration (e.g. "22s")
 * - maxheight: visible area height in px (default 280)
 *
 * Only renders on the front page.
 */
function bl_practice_marquee_shortcode( $atts ) {
    if ( ! is_front_page() ) return '';

    $atts = shortcode_atts( array(
        'parent'    => 'practice-areas',
        'limit'     => 9,
        'speed'     => '22s',
        'maxheight' => 280,
    ), $atts, 'practice_marquee' );

    // find parent page by slug
    $parent_page = get_page_by_path( sanitize_text_field( $atts['parent'] ) );

    if ( ! $parent_page ) {
        return ''; // nothing to display if parent not found
    }

    $args = array(
        'post_type'      => 'page',
        'post_parent'    => $parent_page->ID,
        'posts_per_page' => intval( $atts['limit'] ),
        'orderby'        => 'menu_order',
        'order'          => 'ASC',
        'post_status'    => 'publish',
    );

    $q = new WP_Query( $args );
    if ( ! $q->have_posts() ) return '';

    $items_html = '';
    while ( $q->have_posts() ) {
        $q->the_post();
        $title     = get_the_title();
        $permalink = get_permalink();
        $items_html .= '<li class="pa-item"><a href="' . esc_url( $permalink ) . '">' . esc_html( $title ) . '</a></li>';
    }
    wp_reset_postdata();

    // wrapper with inline CSS variables for easy tuning
    $html  = '<div class="pa-marquee" role="navigation" aria-label="Practice areas"';
    $html .= ' style="--marquee-speed:' . esc_attr( $atts['speed'] ) . '; --pa-max-height:' . intval( $atts['maxheight'] ) . 'px">';
    $html .= '<ul class="pa-list">' . $items_html . $items_html . '</ul>';
    $html .= '</div>';

    return $html;
}
add_shortcode( 'practice_marquee', 'bl_practice_marquee_shortcode' );


// END ENQUEUE PARENT ACTION
